#include <vcl.h>
#pragma hdrstop
#include <atl\atlvcl.h>

#include "MSR_SOImpl.h"
#pragma package(smart_init)

//#define	 DebugMode  TRUE;

USERES("MSRSO.res");
USEUNIT("MSRSO_ATL.cpp");
USETLB("MSRSO.tlb");
USEUNIT("OPOS_TLB.cpp");
USEUNIT("MSR_SOImpl.cpp"); /* MSR_SO: CoClass */
USEFORM("InitTime.cpp", frmAbout);
USEFORM("HealthResult.cpp", frmHealthResult);
//---------------------------------------------------------------------------
TComModule  Project1Module;
TComModule &_Module = Project1Module;

// The ATL Object map holds an array of _ATL_OBJMAP_ENTRY structures that
// described the objects of your OLE server. The MAP is handed to your
// project's CComModule-derived _Module object via the Init method.
//
BEGIN_OBJECT_MAP(ObjectMap)
OBJECT_ENTRY(CLSID_MSR_SO, TMSR_SOImpl)
END_OBJECT_MAP()

// Entry point of your Server invoked by Windows for processes or threads are
// initialized or terminated.
//

static HINSTANCE hInstance;
/*
static HHOOK hKBHook;
LRESULT CALLBACK HookProc(int nCode,WPARAM wParam,LPARAM lParam);
*/
int WINAPI DllEntryPoint(HINSTANCE hinst, unsigned long reason, void*)
{
    HANDLE hShareMemory;
    DWORD  dwError;
    LPVOID lpShareMemoryAddress;
    SMData *MyData;


    hShareMemory=CreateFileMapping(INVALID_HANDLE_VALUE,
                                   NULL,
                                   PAGE_READWRITE,
                                   0,
                                   1024,
                                   "MSRSM");
    dwError=GetLastError();
    lpShareMemoryAddress=MapViewOfFile(hShareMemory,
                                       FILE_MAP_READ|FILE_MAP_WRITE,
                                       0,
                                       0,
                                       sizeof(SMData));
    MyData=(SMData *)lpShareMemoryAddress;
    if (reason == DLL_PROCESS_ATTACH)
    {

        _Module.Init(ObjectMap, hinst);
        DisableThreadLibraryCalls(hinst);

        _Module.Init(ObjectMap, hinst);
        DisableThreadLibraryCalls(hinst);

        //P_@ɰOO_Ĥ@إ
        if (dwError != ERROR_ALREADY_EXISTS)
        {
            MyData->RefCount=1;           //]wpƾ@
            MyData->ClaimedFlag=false;    //M˸mvX
            //]w˸mv
            MyData->ClaimedMutex=CreateMutex(NULL,false,"MSRCM");
            //]w˸mvƥ
            MyData->ReleasedEvent=CreateEvent(NULL,true,true,"MSRRE");
        }
        else
        {
            //@ɰOwإ, Ѧҭpƥ[@
            MyData->RefCount++;
        }

    }
    else if (reason == DLL_PROCESS_DETACH)
    {
        //check share memory if exist
        if (dwError == ERROR_ALREADY_EXISTS)
        {
            //counter -1
            MyData->RefCount--;
        }
    }
    //check
    if (MyData->RefCount == 0)
    {
        //release share memory
        CloseHandle(MyData->ClaimedMutex);
        CloseHandle(MyData->ReleasedEvent);
        UnmapViewOfFile(lpShareMemoryAddress);
        CloseHandle(hShareMemory);
    }
    else
    {
        //share memory is used
        UnmapViewOfFile(lpShareMemoryAddress);
    }
    hInstance=hinst;
    return TRUE;
}

// _Module.Term is typically invoked from the DLL_PROCESS_DETACH of your
// DllEntryPoint. However, this may result in an incorrect shutdown sequence.
// Instead an Exit routine is setup to invoke the cleanup routine
// CComModule::Term.
//
void ModuleTerm(void)
{
    _Module.Term();
}
#pragma exit ModuleTerm 63

// Entry point of your Server invoked to inquire whether the DLL is no
// longer in use and should be unloaded.
//
STDAPI __export DllCanUnloadNow(void)
{
    return (_Module.GetLockCount()==0) ? S_OK : S_FALSE;
}

// Entry point of your Server allowing OLE to retrieve a class object from
// your Server
//
STDAPI __export DllGetClassObject(REFCLSID rclsid, REFIID riid, LPVOID* ppv)
{
    return _Module.GetClassObject(rclsid, riid, ppv);
}

// Entry point of your Server invoked to instruct the server to create
// registry entries for all classes supported by the module
//
STDAPI __export DllRegisterServer(void)
{
    return _Module.RegisterServer(TRUE);
}

// Entry point of your Server invoked to instruct the server to remove
// all registry entries created through DllRegisterServer.
//
STDAPI __export DllUnregisterServer(void)
{
    return _Module.UnregisterServer();
}
//---------------------------------------------------------------------------

